//
//  OPURLTools.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 2012-06-09.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "OnePasswordCoreConstants.h"

NS_ASSUME_NONNULL_BEGIN

@interface OPURLTools : NSObject

+ (OPURLTools *)sharedTools;

@property (nonatomic, readonly) OPTimestamp hashVersion;

- (NSString *)extractSchemeFromURLString:(NSString *)URLString;
- (NSString *)extractSchemeFromURLString:(NSString *)URLString looseParsing:(BOOL)isRelaxed;
- (NSString *)extractHostFromURLString:(NSString *)URLString;
- (NSString *)extractHostFromURLString:(NSString *)URLString looseParsing:(BOOL)isRelaxed;
- (NSString *)applyTransformationsToDomain:(NSString *)domain;
- (nullable NSString *)derivedHashWithSalt:(NSString *)salt forURLString:(NSString *)URLString;
- (NSString *)generateLoginTitleForURLString:(NSString *)URLString;

- (NSString *)nakedDomainForHost:(NSString *)host;
- (nullable NSString *)nakedDomainForURLString:(NSString *)URLString;
- (nullable NSString *)nakedHashWithSalt:(NSString *)salt forURLString:(NSString *)URLString;

- (nullable NSURL *)URLForUnprocessedString:(NSString *)unprocessedString;

- (nullable NSURL *)URLForUserText:(NSString *)text;

- (void)renameThenRemoveItemAtURL:(NSURL *)URL;
- (void)resetAllWebCachesAndData;

- (NSString *)autosaveBlacklist;
- (void)saveScrambledAutosaveBlacklist:(NSString *)plainBlacklist;
- (void)addURLToAutosaveBlacklist:(NSString *)urlString;
- (void)removeURLFromAutosaveBlacklist:(NSString *)urlString;

- (nullable NSURL *)securityScopedURLFromBookmarkData:(NSData *)bookmarkData;
- (void)stopAccessingSecurityScopedURL:(NSURL *)url;
- (nullable NSData *)securityScopedBookmarkDataForURL:(NSURL *)url;

@end

NS_ASSUME_NONNULL_END
